/******************************************************************************\
* Copyright (C) 2012-2013 Leap Motion, Inc. All rights reserved.               *
* Leap Motion proprietary and confidential. Not for distribution.              *
* Use subject to the terms of the Leap Motion SDK Agreement available at       *
* https://developer.leapmotion.com/sdk_agreement, or another agreement         *
* between Leap Motion and you, your company or other organization.             *
\******************************************************************************/

#include <iostream>
#include "Sample.h"
#include "include/Leap.h"
#include "stdlib.h"
#include <QObject>
#include <QThread>

using namespace Leap;


void SampleListener::onInit(const Controller& controller) {
  std::cout << "Initialized" << std::endl;
  Liaison = new Serie();
  Liaison->tour = 1;
  tab[1] = 0;
  tab[2] = 0;
  tab[3] = 0;
  tab[4] = 0;
  tab[5] = 0;
  tab[6] = 0;
  tab[7] = 0;
  tab[8] = 0;
  tab[9] = 0;

}

void SampleListener::onConnect(const Controller& controller) {
  std::cout << "Connected" << std::endl;
  controller.enableGesture(Gesture::TYPE_CIRCLE);
  controller.enableGesture(Gesture::TYPE_KEY_TAP);
  controller.enableGesture(Gesture::TYPE_SCREEN_TAP);
  controller.enableGesture(Gesture::TYPE_SWIPE);
}

void SampleListener::onDisconnect(const Controller& controller) {
  //Note: not dispatched when running in a debugger.
  std::cout << "Disconnected" << std::endl;
}

void SampleListener::onExit(const Controller& controller) {
  std::cout << "Exited" << std::endl;
}

void SampleListener::init_flag(int a){
	flag = a;
}

int SampleListener::getCaseSelect(){
	return num_case_select;
}

void SampleListener::init_coor(){
	x1=-1000;
	x2=-1000;
	z1=-1000;
	z2=-1000;
	x=-1000;
	z=-1000;
}

void SampleListener::init_p_nbr_d(){
	p_nbr_d = 0;
}

void SampleListener::init_tab_cases(float x1, float x2, float z1, float z2){

	tab_cases[0].numero = 1;
	tab_cases[0].x_max = x1 + (x2-x1)/3;
	tab_cases[0].x_min = x1;
	tab_cases[0].z_max = z2;
	tab_cases[0].z_min = z1 + 2*(z2 - z1)/3;
	
	tab_cases[1].numero = 2;
	tab_cases[1].x_max = x1 + 2*(x2- x1)/3;
	tab_cases[1].x_min = x1 + (x2-x1)/3;
	tab_cases[1].z_max = z2;
	tab_cases[1].z_min = z1 + 2*(z2 - z1)/3;
	
	tab_cases[2].numero = 3;
	tab_cases[2].x_max = x2;
	tab_cases[2].x_min = x1 + 2*(x2-x1)/3;
	tab_cases[2].z_max = z2;
	tab_cases[2].z_min = z1 + 2*(z2-z1)/3;
	
	tab_cases[3].numero = 4;
	tab_cases[3].x_max = x1  + (x2-x1)/3;
	tab_cases[3].x_min = x1;
	tab_cases[3].z_max = z1 + 2*(z2-z1)/3;
	tab_cases[3].z_min = z1+(z2-z1)/3;
	
	tab_cases[4].numero = 5;
	tab_cases[4].x_max = x1 + 2*(x2 - x1)/3;
	tab_cases[4].x_min = x1 + (x2-x1)/3;
	tab_cases[4].z_max = z1 + 2*(z2-z1)/3;
	tab_cases[4].z_min = z1 + (z2-z1)/3;
	
	tab_cases[5].numero = 6;
	tab_cases[5].x_max = x2;
	tab_cases[5].x_min = x1 + 2*(x2-x1)/3;
	tab_cases[5].z_max = z1 + 2*(z2-z1)/3;
	tab_cases[5].z_min = z1+(z2-z1)/3;
	
	tab_cases[6].numero = 7;
	tab_cases[6].x_max = x1+(x2-x1)/3;
	tab_cases[6].x_min = x1;
	tab_cases[6].z_max = z1 +(z2-z1)/3;
	tab_cases[6].z_min = z1;
	
	tab_cases[7].numero = 8;
	tab_cases[7].x_max = x1 +2*(x2-x1)/3;
	tab_cases[7].x_min = x1 + (x2-x1)/3;
	tab_cases[7].z_max = z1 + (z2-z1)/3;
	tab_cases[7].z_min = z1;
	
	tab_cases[8].numero = 9;
	tab_cases[8].x_max = x2;
	tab_cases[8].x_min = x1 + 2*(x2-x1)/3;
	tab_cases[8].z_max = z1 +(z2-z1)/3;
	tab_cases[8].z_min = z1;

}

float SampleListener::average_x(FingerList fingers){
	float avgPos = 0;
	int i;
	for (i = 0; i < 2; ++i) {
		avgPos += (fingers[i].tipPosition())[0];
		avgPos /= (float)fingers.count();
	}
	return avgPos;
}

float SampleListener::average_z(FingerList fingers){
	float avgPos = 0;
	int i;
	for (i = 0; i < 2; ++i) {
		avgPos += (fingers[i].tipPosition())[1];
		avgPos /= (float)fingers.count();
	}
	return avgPos;
}

int SampleListener::get_case_current(float x, float z){
	CASE c = tab_cases[0];
	int i  = 0;
	while ( (x>c.x_max || x<c.x_min || z>c.z_max || z<c.z_min) && i<9) {
		i ++;
		c = tab_cases[i];
	}
	if (i==9){
		std::cout << "\nCe point n'appartient pas au damier" << std::endl;
		return 0;
	}
	else {
		num_case_current = c.numero;
	}
	return 1;
}

int SampleListener::get_case_select(float x, float z){
	CASE c = tab_cases[0];
	int i  = 0;
	while ( (x>c.x_max || x<c.x_min || z>c.z_max || z<c.z_min) && i<9) {
		i ++;
		c = tab_cases[i];
	}
	if (i==9){
		std::cout << "\nCe point n'appartient pas au damier" << std::endl;
		return 0;
	}
	else {
		num_case_select = c.numero;
	}
	return 1;
}

///////////////////////////*Mthode principale*/////////////////////////////////////////////////////////

void SampleListener::onFrame(const Controller& controller) {
	
    int mains;
    double i;
    double pouet=0;

	// Get the most recent frame
	const Frame frame = controller.frame();	
	//Enregistrer le nombre de mains visibles			
	mains = frame.hands().count();
	std::cout << "Nombre de main : "<< mains << std::endl;
	
	if (mains > 1) {
		//Si plus de deux mains, rinitialisation du jeu
		std::cout << "\nReinitialisation du jeu" << std::endl;
		flag = 1;
	}
	else {
		// Get the first hand
		const Hand hand = frame.hands()[0];
		// Check if the hand has any fingers
		const FingerList fingers = hand.fingers();

			//Etape 1 : Slction de l'angle en haut  gauche
			if (flag == 1){
				if (fingers.isEmpty()) {
					//Si plus de doigt il faut qu'il y ai eu deux doigts  la boucle prcdente
					if (p_nbr_d == 2 && x1 != -1000 && z2 != -1000){
						flag =2;
						p_nbr_d = 0;
					}
				}
				if(fingers.count() == 2){
					//Si deux doigts, calcul de la position moyenne des deux doigts
					x1 = average_x(fingers);
					z2 = average_z(fingers);
					std::cout << "\nAngle en haut a gauche | x1 : " << x1 <<" z2 : "<< z2 << std::endl;
					p_nbr_d = 2;
				}
			}

			//Etape 2 : Slction de l'angle en bas  droite
			if (flag == 2){
				if (fingers.isEmpty()) {
					//Si plus de doigt il faut qu'il y ai eu deux doigts  la boucle prcdente
					if (p_nbr_d == 2 && x2 != -1000 && z1 != -1000){
						flag =3;
						p_nbr_d = 0;
					}
				}
				if(fingers.count() == 2){
					//Si deux doigts, calcul de la position moyenne des deux doigts
					x2 = average_x(fingers);
					z1 = average_z(fingers);
					std::cout << "\nAngle en bas a droite | x2 : " << x2 <<" z1 : "<< z1 << std::endl;
					p_nbr_d = 2;
				}
			}

			//Etape 3 : Initialisation des coordonnes de chaque case  partir des deux angles dtermins
			if (flag == 3){
				SampleListener::init_tab_cases(x1,x2,z1,z2);
				flag = 4;
			}

			//Etape 4 : Jeu
			if (flag == 4){
				if (fingers.isEmpty()) {
					//Si dtection d'aucun doigt alors vrification qu'il y avait deux doigts  la boucle prcdente
					if (p_nbr_d == 2 && x != -1000 && z != -1000){
						//Si deux doigts  la boucle prcdente alors criture de la case slectionne dans l'attribut "num_case_select"
						if (SampleListener::get_case_select(x,z)){
							std::cout << "\nCase selectionnee : " << num_case_select << std::endl;
                            this->res = num_case_select;
                            if(tab[this->res] == 0)
                            {

                                Liaison->FetchPion();


                                Liaison->sendData2(15);
                                Liaison->sendData3(146);
                                Liaison->sendData4(45);
                                Liaison->sendData5(60);
                                Liaison->sendData1(125);
                                while(i<2000000000)
                                {
                                    pouet = pouet+1/i;
                                    i++;
                                }
                                std::cout << "\n Envoie des donnees ";
                                //Liaison->PosA1_defaut();


                                if(this->res ==1)
                                {
                                    Liaison->PosA1_defaut();

                                }
                                else if(this->res == 2)
                                {
                                    //emit SampleListener::SpottedCaseA2();
                                    Liaison->PosA2_defaut();
                                }
                                else if(this->res == 3)
                                {
                                    // emit SampleListener::SpottedCaseA3();
                                    Liaison->PosA3_defaut();

                                }
                                else if(this->res == 4)
                                {
                                    //emit SampleListener::SpottedCaseB1();
                                    Liaison->PosB1_defaut();

                                }
                                else if(this->res == 5)
                                {
                                    //emit SampleListener::SpottedCaseB2();
                                    Liaison->PosB2_defaut();

                                }
                                else if(this->res == 6)
                                {
                                    //emit SampleListener::SpottedCaseB3();
                                    Liaison->PosB3_defaut();

                                }
                                else if(this->res == 7)
                                {
                                    //emit SampleListener::SpottedCaseC1();
                                    Liaison->PosC1_defaut();

                                }
                                else if(this->res== 8)
                                {
                                   // emit SampleListener::SpottedCaseC2();
                                    Liaison->PosC2_defaut();

                                }
                                else if(this->res == 9)
                                {
                                    //emit SampleListener::SpottedCaseC3();
                                    Liaison->PosC3_defaut();
                                }

                                tab[this->res] = 1;
                            }
						}
					}
				}
				if(fingers.count() == 2){
					//Si dtection de deux doigts alors calcul de la position moyenne des doigts et affichage de la case survole  l'utilisateur
					x = average_x(fingers);
					z = average_z(fingers);
					std::cout << "\nNon fixes - x : " << x <<" z : "<< z << std::endl;
					p_nbr_d = 2;
					if (SampleListener::get_case_current(x,z)){
							std::cout << "\nCase survolee : " << num_case_current << std::endl;


					}

				}
			}
			
	}
	
	//Sleep(200);
    //system("clear");
}

void SampleListener::onFocusGained(const Controller& controller) {
  std::cout << "Focus Gained" << std::endl;
}

void SampleListener::onFocusLost(const Controller& controller) {
  std::cout << "Focus Lost" << std::endl;
}
/*
int main() {

	

  // Create a sample listener and controller
  SampleListener listener;
  Controller controller;
	
	listener.init_p_nbr_d();
	listener.init_flag(1);
	listener.init_coor();

  // Have the sample listener receive events from the controller
  controller.addListener(listener);

  // Keep this process running until Enter is pressed

  std::cout << "Press Enter to quit..." << std::endl;
  std::cin.get();

  // Remove the sample listener when done
  controller.removeListener(listener);

  return 0;
}*/
