#ifndef SAMPLE_H
#define SAMPLE_H

#include <iostream>
#include "include/Leap.h"
#include "stdlib.h"
#include <QObject>
#include <QThread>
#include "Serie.h"
#ifdef _WIN32
#include <Windows.h>
#endif
using namespace Leap;



class SampleListener : public QObject, public Listener
{
    Q_OBJECT;
  public:
    virtual void onInit(const Controller&);
    virtual void onConnect(const Controller&);
    virtual void onDisconnect(const Controller&);
    virtual void onExit(const Controller&);
    virtual void onFrame(const Controller&);
    virtual void onFocusGained(const Controller&);
    virtual void onFocusLost(const Controller&);
	virtual void init_flag(int a);
	virtual void init_tab_cases(float x1, float x2, float y1, float y2);
	virtual void init_coor();
	virtual int get_case_current(float x, float y);
	virtual int get_case_select(float x, float y);
	virtual float average_x(FingerList fingers);
	virtual float average_z(FingerList fingers);
	virtual void init_p_nbr_d();
	virtual int getCaseSelect();

private :

	CASE tab_cases[9];
	int flag;
	int num_case_current;
	int num_case_select;
	float x1, x2, z1, z2, x, z;
	int p_nbr_d;
    Serie* Liaison;
    int res;
    int tab[10];

signals:
    void SpottedCaseA1();
    void SpottedCaseA2();
    void SpottedCaseA3();
    void SpottedCaseB1();
    void SpottedCaseB2();
    void SpottedCaseB3();
    void SpottedCaseC1();
    void SpottedCaseC2();
    void SpottedCaseC3();

};
#endif

