#include "Serie.h"
#include "Sample.h"

Serie::Serie() : QObject()
{
//initialisation de la liaison série
m_serialPort = new QextSerialPort("/dev/ttyACM0"); // établit la connexion avec le port

if ( !m_serialPort->open( QIODevice::ReadWrite | QIODevice::Unbuffered ) )
{
    std::cout << "Le Robot n'est pas là";
    exit(EXIT_FAILURE);
}
else
{
    m_serialPort->setBaudRate(BAUD9600);
    m_serialPort->setFlowControl(FLOW_OFF);
    m_serialPort->setParity(PAR_NONE);
    m_serialPort->setDataBits(DATA_8);
    m_serialPort->setStopBits(STOP_1);
}




//mise en place de la fenêtre
   
//mise en place des sliders


//mise en place des boutons permettant le ramassage des pions


//mise en place du bouton de remise en position de repos


    //connexion des slots
    //bouton repos
    /*QObject::connect(m_bouton_repos, SIGNAL(clicked()),this,SLOT(RemisePosRepos()));
    //boutons de position morpion
    QObject::connect(m_bouton1,SIGNAL(clicked()),this,SLOT(PosA1_defaut()));
    QObject::connect(m_bouton2,SIGNAL(clicked()),this,SLOT(PosA2_defaut()));
    QObject::connect(m_bouton3,SIGNAL(clicked()),this,SLOT(PosA3_defaut()));
    QObject::connect(m_bouton4,SIGNAL(clicked()),this,SLOT(PosB1_defaut()));
    QObject::connect(m_bouton5,SIGNAL(clicked()),this,SLOT(PosB2_defaut()));
    QObject::connect(m_bouton6,SIGNAL(clicked()),this,SLOT(PosB3_defaut()));
    QObject::connect(m_bouton7,SIGNAL(clicked()),this,SLOT(PosC1_defaut()));
    QObject::connect(m_bouton8,SIGNAL(clicked()),this,SLOT(PosC2_defaut()));
    QObject::connect(m_bouton9,SIGNAL(clicked()),this,SLOT(PosC3_defaut()));
    //boutons de récupération de pions
    QObject::connect(m_bouton_ramasse_eq1,SIGNAL(clicked()),this,SLOT(Ramasse_eq1()));
    QObject::connect(m_bouton_ramasse_eq2,SIGNAL(clicked()),this,SLOT(Ramasse_eq2()));
    //bouton de noubelle partie
    QObject::connect(m_bouton_nouvelle_partie,SIGNAL(clicked()),this,SLOT(NouvellePartie()));
    QObject::connect(m_bouton_reinit_pos,SIGNAL(clicked()),this,SLOT(reinit()));

    //connexion des sliders avec le port série
    /*QObject::connect(m_slider1, SIGNAL(valueChanged(int)) ,this,SLOT(sendData1(int)));
    QObject::connect(m_slider2, SIGNAL(valueChanged(int)) ,this,SLOT(sendData2(int)));
    QObject::connect(m_slider3, SIGNAL(valueChanged(int)) ,this,SLOT(sendData3(int)));
    QObject::connect(m_slider4, SIGNAL(valueChanged(int)) ,this,SLOT(sendData4(int)));
    QObject::connect(m_slider5, SIGNAL(valueChanged(int)) ,this,SLOT(sendData5(int)));
    QObject::connect(m_slider6, SIGNAL(valueChanged(int)) ,this,SLOT(sendData6(int)));*/


}

void Serie::FetchPion()
{
    double pouet = 0;
    double i=1;
    switch (tour)
    {
    case 1:

        // Premier tour, les bleus commencent
        sendData6(30);
        sendData1(178);
        sendData3(106);
        sendData4(25);
        sendData5(110);
        sendData2(75);
        sendData6(70);



        tour++;
        break;


    case 2:

        // 1er tour des noirs
        sendData6(30);
        sendData1(56);
        sendData3(116);
        sendData4(25);
        sendData5(10);
        sendData2(65);
        sendData6(70);
        tour++;
        break;


    case 3:

        // 2e tour des bleus
        sendData6(30);
        sendData1(170);
        sendData3(96);
        sendData4(25);
        sendData5(90);
        sendData2(75);
        sendData6(70);
        tour++;
        break;


    case 4:

        // 2e tour des noirs
        sendData6(30);
        sendData1(65);
        sendData3(116);
        sendData4(35);
        sendData5(20);
        sendData2(65);
        sendData6(70);
        tour++;
        break;


    case 5:

        //3e tour des bleus
        sendData6(30);
        sendData1(165);
        sendData3(86);
        sendData4(25);
        sendData5(90);
        sendData2(75);
        sendData6(70);
        tour++;
        break;


    case 6:

        // 3e tour des noirs

        sendData6(30);
        sendData1(70);
        sendData3(100);
        sendData4(25);
        sendData5(20);
        sendData2(75);
        sendData6(70);
        tour++;
        break;


    case 7:

        // 4e tour des bleus
        sendData6(30);
        sendData1(158);
        sendData3(70);
        sendData4(15);
        sendData5(90);
        sendData2(90);
        sendData6(70);
        tour++;
        break;


     case 8:

        // 4e tour des noirs
        sendData6(30);
        sendData1(93);
        sendData3(25);
        sendData4(20);
        sendData5(75);
        sendData2(85);
        sendData6(70);
        tour++;
        break;


    case 9:

        // 5e tour des bleus
        sendData6(30);
        sendData1(155);
        sendData3(46);
        sendData4(0);
        sendData5(75);
        sendData2(95);
        sendData6(80);
        tour++;
        break;
    }



    //sendData6(130);



}

//création des slots

//position de repos
void Serie::RemisePosRepos() //reste à définir les valeurs de position de repos!!
{
    /*if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }
    else
    {
    /* Appeler sendData plutôt 
    
    
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);
    m_slider6 -> setValue(130);
    */
    sendData2(15);
    sendData3(146);
    sendData4(45);
    sendData5(60);
    sendData1(125);
    sendData6(130);
    
    

}

//mise en position de jeu
void Serie::PosC3_defaut()
{
   /* if(joueur==1)
    {
        m_bouton9 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton9->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton9 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton9->setEnabled(false);
        joueur=20;
    }
*/

    // sendata plutôt
     std::cout << "Donnees reçues" << std::endl;
    sendData3(86);
    sendData4(35);
    sendData5(60);
    sendData1(105);
    sendData2(80);
    sendData6(30);

    RemisePosRepos();

}

void Serie::PosC2_defaut()
{
    /*
    m_slider3 -> setValue(95);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(117);
    m_slider2 -> setValue(79);
    m_slider6 -> setValue(30);
    */
    std::cout << "Donnees reçues" << std::endl;

    sendData3(95);
    sendData4(35);
    sendData5(60);
    sendData1(117);
    sendData2(79);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosC1_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

    /*
    m_slider3 -> setValue(86);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(135);
    m_slider2 -> setValue(86);
    m_slider6 -> setValue(30);
    */
    sendData3(80);
    sendData4(25);
    sendData5(65);
    sendData1(130);
    sendData2(86);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosB3_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

   /*
    m_slider3 -> setValue(106);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(100);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    */
    sendData3(106);
    sendData4(35);
    sendData5(60);
    sendData1(100);
    sendData2(65);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosB2_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

    /*
    m_slider3 -> setValue(110);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(120);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    */
    sendData3(110);
    sendData4(35);
    sendData5(60);
    sendData1(115);
    sendData2(65);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosB1_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

    /*
    m_slider3 -> setValue(106);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(140);
    m_slider2 -> setValue(75);
    m_slider6 -> setValue(30);
    */
    sendData3(106);
    sendData4(35);
    sendData5(60);
    sendData1(140);
    sendData2(75);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosA3_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

    /*20;
    }
    m_slider3 -> setValue(126);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(87);
    m_slider2 -> setValue(55);
    m_slider6 -> setValue(30);
    */
    
    sendData3(126);
    sendData4(35);
    sendData5(60);
    sendData1(87);
    sendData2(55);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosA2_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

    /*
    m_slider3 -> setValue(136);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(120);
    m_slider2 -> setValue(55);
    m_slider6 -> setValue(30);
    */
    sendData3(136);
    sendData4(45);
    sendData5(60);
    sendData1(120);
    sendData2(55);
    sendData6(30);
    RemisePosRepos();
}

void Serie::PosA1_defaut()
{
    std::cout << "Donnees reçues" << std::endl;

   /*
    m_slider3 -> setValue(126);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(145);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    */
    sendData3(125);
    sendData4(35);
    sendData5(60);
    sendData1(145);
    sendData2(65);
    sendData6(30);

    RemisePosRepos();

}

/*
//mise en position de prise de pion
void MaFenetre::Ramasse_eq1()
{   if(joueur==10) //cela est signe que c'est l'équipe 1 qui a joué le dernier coup
    {
        QMessageBox::critical(this, "Tricheur !", "Ce n'est pas à votre tour de jouer !!");
    }
    else if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }
    else
    {
  //il se baisse pour ramasser le pion en fonction du tour où l'on se trouve
    if(tour_eq1==1)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(178);
        m_slider3 -> setValue(106);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(110);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==2){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(170);
        m_slider3 -> setValue(96);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==3){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(162);
        m_slider3 -> setValue(76);
        m_slider4 -> setValue(15);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(85);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==4){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(160);
        m_slider3 -> setValue(66);
        m_slider4 -> setValue(15);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(90);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==5){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(155);
        m_slider3 -> setValue(65);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(75);
        m_slider2 -> setValue(95);
        m_slider6 -> setValue(80);
        tour_eq1++;
    }
    else
    {
      QMessageBox::warning(this, "Attention", "L'équipe 1 n'a plus de pion !!");  //signale que le joueur n'a plus de pion
    }

  //il revient en position de repos
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);


    joueur = 1;
    }
}

void MaFenetre::Ramasse_eq2()
{
    if(joueur==20) //cela indique que c'est l'équipe 2 qui a joué le dernier coup
    {
        QMessageBox::critical(this, "Tricheur !", "Ce n'est pas à votre tour de jouer !!");
    }
    else if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }
    else {
  //il se baisse pour ramasser le pion
    if(tour_eq2==1)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(60);
        m_slider3 -> setValue(126);
        m_slider4 -> setValue(45);
        m_slider5 -> setValue(10);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==2)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(70);
        m_slider3 -> setValue(106);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(20);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==3)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(75);
        m_slider3 -> setValue(96);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(20);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==4) //revoir cette position !!!!!!
    {
        m_slider6 -> setValue(30);
        m_slider3 -> setValue(93);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(30);
        m_slider1 -> setValue(80);
        m_slider2 -> setValue(85);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==5)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(85);
        m_slider3 -> setValue(66);
        m_slider4 -> setValue(5);
        m_slider5 -> setValue(40);
        m_slider2 -> setValue(95);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else
    {
        QMessageBox::warning(this, "Attention", "L'équipe 2 n'a plus de pion !!");  //signale que le joueur n'a plus de pion
    }

  //il revient en position de repos
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);


    joueur = 2;
}
}
void MaFenetre::NouvellePartie()
{
    if(joueur==1||joueur==2)
    {
        m_slider3 -> setValue(136);
        m_slider4 -> setValue(25);
        m_slider1 -> setValue(180);
        m_slider5 -> setValue(50);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(30);
    }
    //remise des servos en position de repos
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider2 -> setValue(15);
    m_slider1 -> setValue(125);
    m_slider6 -> setValue(130);

    joueur =0 ; //remise du joueur à personne et des indicateur du tour à 1
    tour_eq1=1;
    tour_eq2=1;

//réinitialisation des cases du jeu
    m_bouton1 -> setStyleSheet("default");
    m_bouton1->setEnabled(true);
    m_bouton2 -> setStyleSheet("default");
    m_bouton2->setEnabled(true);
    m_bouton3 -> setStyleSheet("default");
    m_bouton3->setEnabled(true);
    m_bouton4 -> setStyleSheet("default");
    m_bouton4->setEnabled(true);
    m_bouton5 -> setStyleSheet("default");
    m_bouton5->setEnabled(true);
    m_bouton6 -> setStyleSheet("default");
    m_bouton6->setEnabled(true);
    m_bouton7 -> setStyleSheet("default");
    m_bouton7->setEnabled(true);
    m_bouton8 -> setStyleSheet("default");
    m_bouton8->setEnabled(true);
    m_bouton9 -> setStyleSheet("default");
    m_bouton9->setEnabled(true);

}

void MaFenetre::reinit()
{
    QMessageBox::information(this, "Réinitialisation des Coordonnées", "Cette Fonction n'est pas encore disponible");
}
*/
void Serie::sendData1(int data)
{

    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=1000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void Serie::sendData2(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=2000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void Serie::sendData3(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=3000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void Serie::sendData4(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=4000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void Serie::sendData5(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=5000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void Serie::sendData6(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=6000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

Serie::~Serie() // Destructeur
{
    delete m_serialPort;
}

