#ifndef MAFENETRE_H
#define MAFENETRE_H

#include <QApplication>
#include <QWidget>
#include <QPushButton>
#include <QSlider>
#include <QLCDNumber>
#include <QMessageBox>
#include <qextserialport.h>
#include <stdio.h>


class MaFenetre : public QWidget//on hérite de QWidget !! (IMPORTANT)
{
   Q_OBJECT

public:
    MaFenetre();
    ~MaFenetre();



public slots:   //création de nos propres slots permettant les diverses fonctions réalisée par l'appui sur les différents boutons
    void RemisePosRepos(); //remise en position de repos
  //mise en position de dépôt de pion
    void PosA1_defaut();
    void PosA2_defaut();
    void PosA3_defaut();
    void PosB1_defaut();
    void PosB2_defaut();
    void PosB3_defaut();
    void PosC1_defaut();
    void PosC2_defaut();
    void PosC3_defaut();
  //ramasser pion dans l'équipe 1 ou 2
    void Ramasse_eq1();
    void Ramasse_eq2();
  //nouvelle partie
    void NouvellePartie();
  //réinitialisation des coordonnées
    void reinit();
  //slots de connexion des sliders aux servos
    void sendData1(int data);
    void sendData2(int data);
    void sendData3(int data);
    void sendData4(int data);
    void sendData5(int data);
    void sendData6(int data);

private:
    //creation des boutons de position
    QPushButton *m_bouton1;
    QPushButton *m_bouton2;
    QPushButton *m_bouton3;
    QPushButton *m_bouton4;
    QPushButton *m_bouton5;
    QPushButton *m_bouton6;
    QPushButton *m_bouton7;
    QPushButton *m_bouton8;
    QPushButton *m_bouton9;

    //création des 6 sliders rapprochés aux servomoteurs
    QSlider *m_slider1;
    QSlider *m_slider2;
    QSlider *m_slider3;
    QSlider *m_slider4;
    QSlider *m_slider5;
    QSlider *m_slider6;
    //création des afficheurs d'angles correspondants
    QLCDNumber *m_lcd1;
    QLCDNumber *m_lcd2;
    QLCDNumber *m_lcd3;
    QLCDNumber *m_lcd4;
    QLCDNumber *m_lcd5;
    QLCDNumber *m_lcd6;

    //création des boutons de ramassage des pions
    QPushButton *m_bouton_ramasse_eq1;
    QPushButton *m_bouton_ramasse_eq2;

    //création bouton remise en position de repos
    QPushButton *m_bouton_repos;

    //création de bouton de réinitilisation de position de repos
    QPushButton *m_bouton_reinit_pos;

    //création du bouton de nouvelle partie
    QPushButton *m_bouton_nouvelle_partie;

    int joueur; //variable désignant quel est l'équipe en train de jouer(si 0 : personne ; si 1 : équipe 1 (bleue) ; si 2 : équipe 2 (noire) + 10 si c'est le joueur 1 qui vient de jouer et 20 si c'est le joueur 2 qui vient de jouer)
    //variables indiquant l'indice du pion à récupérer pour chaque équipe
    int tour_eq1;
    int tour_eq2;

    //liaison série
    QextSerialPort *m_serialPort;

    //bouton témoin de la liaison série
    QPushButton *m_bouton_temoin;

};

#endif // MAFENETRE_H
